/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.base.logd;

import com.ibm.hwmca.base.logd.EventLogData;
import com.ibm.hwmca.base.util.BaseTextBundle;
import com.ibm.hwmca.fw.log.Log;
import com.ibm.hwmca.fw.util.HexString;
import com.ibm.hwmca.fw.util.LocalizableText;
import com.ibm.hwmca.fw.util.Trace;

public class CreateEventLogData {
    private static final String TRACE_MASKT = "XLOGDTCT";
    private static final String TRACE_MASKF = "XLOGDTCF";
    private static final String TRACE_MASKD = "XLOGDTCD";
    private static final LocalizableText _lStrError = new LocalizableText(BaseTextBundle.getBundleName(), "logd.eventsummary.error");
    private static final LocalizableText _lStrInfo = new LocalizableText(BaseTextBundle.getBundleName(), "logd.eventsummary.info");

    public void createEventLogData(Log[] logData, int logIndex, EventLogData[] eventLogData) {
        int numRowsToSet = eventLogData.length;
        Trace.trace(TRACE_MASKF, "create EventLogData object: logIndex=" + logIndex + " numRows=" + numRowsToSet);
        int i = 0;
        while (i < numRowsToSet) {
            String logClassStr = HexString.toHex(logData[logIndex].getLogClass(), true).toUpperCase();
            Trace.trace(TRACE_MASKD, "class = " + logClassStr);
            String logTypeStr = HexString.toHex(logData[logIndex].getLogType(), true).toUpperCase();
            Trace.trace(TRACE_MASKD, "type = " + logTypeStr);
            Short logUser = new Short(logData[logIndex].getUser());
            short lUser = logUser;
            short swapUser = (short)((lUser & 0xFF) << 8 | lUser >> 8 & 0xFF);
            String logUserStr = HexString.toHex(swapUser, true).toUpperCase();
            Trace.trace(TRACE_MASKD, "user = " + logUserStr);
            String eventIdStr = logClassStr + logTypeStr + logUserStr;
            Trace.trace(TRACE_MASKD, "eventId=" + eventIdStr);
            eventLogData[i].setEventId(eventIdStr);
            eventLogData[i].setDate(logData[logIndex].getTimestamp());
            if (logData[logIndex].isError()) {
                eventLogData[i].setType(_lStrError);
            } else {
                eventLogData[i].setType(_lStrInfo);
            }
            Trace.trace(TRACE_MASKD, "IEtype = " + logData[logIndex].isError());
            String nameString = logData[logIndex].getEventName();
            eventLogData[i].setName(nameString);
            Trace.trace(TRACE_MASKD, "name = " + nameString);
            String dataString = logData[logIndex].getTowerData();
            eventLogData[i].setData(dataString);
            ++logIndex;
            ++i;
        }
    }

    public EventLogData createEventLogData(Log logData) {
        EventLogData[] eventLogData = new EventLogData[]{new EventLogData()};
        Log[] oneLog = new Log[]{logData};
        this.createEventLogData(oneLog, 0, eventLogData);
        return eventLogData[0];
    }

    public EventLogData[] createEventLogData(Log logData, EventLogData[] eventLogData) {
        Log[] oneLog = new Log[]{logData};
        this.createEventLogData(oneLog, 0, eventLogData);
        return eventLogData;
    }
}

